/************************************************************************
 * \file: trace_protocol.h
 *
 * \version: $Id: trace_protocol.h,v 1.17 2012/02/16 11:51:45 arun.v Exp $
 *
 * This file implements Trace protocol.
 *
 * \component: Gen2 Trace
 *
 * \author B. Das         bhaskar.das(o)in.bosch.com
          Sakthivelu S.  sakthivelu.s(o)in.bosch.com
 *\modified: Arun V
 * \copyright: (c) 2003 - 2009 ADIT
 *
 ***********************************************************************/
#ifndef _TRACE_PROTOCOL_H_
#define _TRACE_PROTOCOL_H_

/* PRQA: Lint Message 46: As fixing may alter trace protocol header currently deactivating */
/*lint -save -e46 */

typedef struct _TRACE_MULTI_PACK_HDR
{
  U8 len            : 8;
  U8 proc_id        : 4;
  U8 core_no        : 4;
  U8 pack_typ       : 4;
  U8 multi_pack     : 4;
}TRACE_MULTI_PACK_HDR;

typedef struct _TRACE_MULTI_PACK_ID
{
  U8 id1            : 8;
  U8 id2            : 8;
  U8 id3            : 8;
}TRACE_MULTI_PACK_ID;

/* Packet strcture: TRACE to TTFis */
typedef struct _TRACE_OUT_HDR
{
  U8 len            : 8;
  U8 proc_id        : 4;
  U8 core_no        : 4;
  U8 pack_typ       : 4;
  U8 multi_pack     : 4;
  U8 comp_id        : 8;
  U8 class_id       : 8;
  U8 level          : 8;
  U8 state_byte     : 8;
  U8 rsvd           : 8;
}TRACE_OUT_HDR;

typedef struct TRACE_OUT_PKT
{
  TRACE_OUT_HDR hdr;
  U8            payld[240];
}TRACE_OUT_PKT;

typedef struct _TRACE_OUT_MULTI_START_PKT
{
  TRACE_OUT_HDR         hdr;
  TRACE_MULTI_PACK_ID   pack_id;
  U8                    payld[237];
}TRACE_OUT_MULTI_START_PKT;

typedef struct _TRACE_OUT_MULTI_MIDDLE_PKT
{
  TRACE_MULTI_PACK_HDR    hdr;
  TRACE_MULTI_PACK_ID     pack_id;
  U8                      payld[242];
}TRACE_OUT_MULTI_MIDDLE_PKT;

typedef struct _TRACE_OUT_MULTI_END_PKT
{
  TRACE_MULTI_PACK_HDR    hdr;
  TRACE_MULTI_PACK_ID     pack_id;
  U8                      payld[242]; /* Fix:include checksum length */
}TRACE_OUT_MULTI_END_PKT;

typedef union _TRACE_OUT_MSG
{
  TRACE_OUT_PKT              out_pkt;
  TRACE_OUT_MULTI_START_PKT  multi_s_pkt;
  TRACE_OUT_MULTI_MIDDLE_PKT multi_m_pkt;
  TRACE_OUT_MULTI_END_PKT    multi_e_pkt;
} TRACE_OUT_MSG;

/* Packet strcture: TTFis to TRACE */
typedef struct _TRACE_IN_HDR
{
  U8 len            : 8;
  U8 proc_id        : 4;
  U8 core_no        : 4;
  U8 pack_typ       : 4;
  U8 multi_pack     : 4;
  U8 cmd_type       : 8;
}TRACE_IN_HDR;

typedef union
{
  U8 sub_cmd : 8;
  U8 payld[240];
}TRACE_sub_cmd;

typedef struct
{
  TRACE_IN_HDR  hdr;
  TRACE_sub_cmd payld;
}TRACE_in_cmd_pkt;

typedef struct
{
  TRACE_IN_HDR hdr;
  U8           payld[239];
}TRACE_in_chnl_pkt;

typedef struct _TRACE_MULTI_NORM_PKT
{
  TRACE_IN_HDR hdr;
  U8           chnl_id;
  U8           rsvd;
  U8           payld[240];
}TRACE_IN_MULTI_NORM_PKT;

typedef struct _TRACE_IN_MULTI_START_PKT
{
  TRACE_IN_HDR        hdr;
  U8                  chnl_id        : 8;
  U8                  rsvd           : 8;
  TRACE_MULTI_PACK_ID pack_id;
  U8                  payld[237];
}TRACE_IN_MULTI_START_PKT;

typedef struct _TRACE_IN_MULTI_MIDDLE_PKT
{
  TRACE_MULTI_PACK_HDR hdr;
  TRACE_MULTI_PACK_ID  pack_id;
  U8                   payld[240];
}TRACE_IN_MULTI_MIDDLE_PKT;

typedef struct _TRACE_IN_MULTI_END_PKT
{
  TRACE_MULTI_PACK_HDR hdr;
  TRACE_MULTI_PACK_ID  pack_id;
  U8                   payld[240]; /* Fix:include checksum length */
}TRACE_IN_MULTI_END_PKT;

typedef union _TRACE_IN_MSG
{
  TRACE_in_cmd_pkt          cmd_pkt;
  TRACE_in_chnl_pkt         chnl_pkt;
  TRACE_IN_MULTI_NORM_PKT   multi_n_pkt;
  TRACE_IN_MULTI_START_PKT  multi_s_pkt;
  TRACE_IN_MULTI_MIDDLE_PKT multi_m_pkt;
  TRACE_IN_MULTI_END_PKT    multi_e_pkt;
}TRACE_IN_MSG;

/* 32-bit time stamp msg */
typedef struct _TRACE_TIMESTAMP_32B
{
  U32  time;
}TRACE_TIMESTAMP_32B;

/* 64-bit time stamp msg */
typedef struct _TRACE_TIMESTAMP_64B
{
   S32       hi;                     /* Upper 32 bits */
   U32       lo;                     /* Lower 32 bits */
}TRACE_TIMESTAMP_64B;

/* Fix me: RTC time stamp msg */
typedef struct _TRACE_RTC
{
   S32       hi;                     /* Upper 32 bits */
   U32       lo;                     /* Lower 32 bits */
}TRACE_RTC;

/* Possible types of time stamp msg */
typedef union _TRACE_TIMESTAMP_FMT
{
  TRACE_TIMESTAMP_32B tm_32b;
  TRACE_TIMESTAMP_64B tm_64b;
  TRACE_RTC           tm_rtc;
}TRACE_TIMESTAMP_FMT;

typedef struct _TRACE_TIMESTAMP_MSG
{
  TRACE_OUT_HDR       hdr;
  TRACE_TIMESTAMP_FMT payload;
}TRACE_TIMESTAMP_MSG;

/* Timestamp mode */
typedef enum _TRACE_TIMESTAMP_MODE
{
  TRACE_TIMESTAMP_DISABLE = 0x00,   /* Disabled           */
  TRACE_TIMESTAMP_32BIT   = 0x01,   /* Enabled 32bit mode */
  TRACE_TIMESTAMP_64BIT   = 0x02,   /* Enabled 64bit mode */
  TRACE_TIMESTAMP_RTC     = 0x03    /* Enabled, RTC       */
}TRACE_TIMESTAMP_MODE;

/* Possible types of traceout msg */
typedef struct _TRACE_TRACEOUT_MSG
{
  TRACE_TIMESTAMP_MODE tm_stamp;
  struct
  {
    TRACE_TIMESTAMP_MSG tm_msg;
    TRACE_OUT_MSG       trc_msg;
  }pkt;
}TRACE_TRACEOUT_MSG;

typedef struct _TRACE_ISP_HDR
{
  U32 cmd   : 16;
  U32 rsvd  : 16;
  U32 port ;
  U32 sock ;
}TRACE_ISP_HDR;

typedef struct ATTRIBUTE((__packed__))
{
  U8 file_stat : 4;
  U8 file_mode : 4;

}TRACE_MODE_STAT;

typedef union ATTRIBUTE((__packed__))
{
  TRACE_MODE_STAT mode_stat;
  U8 tmp;

}TRACE_MS;

typedef struct ATTRIBUTE((__packed__))
{
  U32 sign;
  TRACE_MS ms;
  U32 over_wr_cnt;

}TRACE_PROXY_HDR;

typedef struct ATTRIBUTE((__packed__))
{
  U8 sub_cmd;
  U8 rsvd_1;
  U8 append;
  U8 file_nm_sz;
  /* We have a string field in the incoming msg from TTFis */
}TRACE_PROXY_CFG_HDR_1;

typedef struct ATTRIBUTE((__packed__))
{
  U8 timestamp_mode;
  U8 per_file_sz;      /* In MB */
  U16 clas_inf;
  U8 lvl_inf;
}TRACE_PROXY_CFG_HDR_2;


typedef struct
{
  U8 status;
  U8 payld[15];
}TRACE_status_msg;

typedef struct
{
  U8 status;
  U8 payld[240];
}TRACE_status_str;

typedef struct
{
  U32                msg_ptn_1;
  TRACE_TIMESTAMP_MSG  tm_msg;
  U32                msg_ptn_2;
  TRACE_OUT_MSG       trc_msg;
}TRACE_PRXY_MSG;

/*lint -restore */

#endif
